package ru.yandex.travel.orders.workflows.invoice.trust;

import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.entities.TrustInvoice;
import ru.yandex.travel.orders.services.payments.TrustHotelsProperties;
import ru.yandex.travel.orders.services.payments.TrustXpayProperties;
import ru.yandex.travel.orders.workflow.invoice.proto.ETrustInvoiceState;
import ru.yandex.travel.orders.workflows.invoice.trust.handlers.ClearedStateHandler;
import ru.yandex.travel.orders.workflows.invoice.trust.handlers.ClearingStateHandler;
import ru.yandex.travel.orders.workflows.invoice.trust.handlers.HoldStateHandler;
import ru.yandex.travel.orders.workflows.invoice.trust.handlers.NewStateHandler;
import ru.yandex.travel.orders.workflows.invoice.trust.handlers.RefundingStateHandler;
import ru.yandex.travel.orders.workflows.invoice.trust.handlers.TerminalStateHandler;
import ru.yandex.travel.orders.workflows.invoice.trust.handlers.WaitForPaymentStateHandler;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
@EnableConfigurationProperties({TrustHotelsProperties.class, TrustXpayProperties.class})
public class TrustInvoiceWorkflowConfiguration {

    @Autowired
    private EntityStateTransitionRepository entityStateTransitionRepository;

    @Autowired
    private NewStateHandler newStateHandler;

    @Autowired
    private WaitForPaymentStateHandler paymentWaitingEventHandler;

    @Autowired
    private HoldStateHandler paymentHoldEventHandler;

    @Autowired
    private ClearedStateHandler clearedStateHandler;

    @Autowired
    private ClearingStateHandler clearingStateHandler;

    @Autowired
    private RefundingStateHandler refundingStateHandler;

    @Autowired
    private TerminalStateHandler terminalStateHandler;

    @Bean
    public WorkflowEventHandler trustInvoiceWorkflowEventHandler() {
        ImmutableMap.Builder<ETrustInvoiceState, StatefulWorkflowEventHandler<ETrustInvoiceState, TrustInvoice>> builder = ImmutableMap.builder();
        builder.put(ETrustInvoiceState.IS_NEW, newStateHandler)
                .put(ETrustInvoiceState.IS_WAIT_FOR_PAYMENT, paymentWaitingEventHandler)
                .put(ETrustInvoiceState.IS_HOLD, paymentHoldEventHandler)
                .put(ETrustInvoiceState.IS_CLEARING, clearingStateHandler)
                .put(ETrustInvoiceState.IS_CLEARED, clearedStateHandler)
                .put(ETrustInvoiceState.IS_REFUNDING, refundingStateHandler)
                // these states are terminal, so any unknown message sent to them will lead to exception
                // some of the messages are safely ignored (e.g. TScheduleClearing)
                .put(ETrustInvoiceState.IS_PAYMENT_NOT_AUTHORIZED, terminalStateHandler)
                .put(ETrustInvoiceState.IS_REFUNDED, terminalStateHandler)
                .put(ETrustInvoiceState.IS_CANCELLED, terminalStateHandler);

        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }
}
