package ru.yandex.travel.orders.workflows.invoice.trust.handlers;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import ru.yandex.travel.orders.entities.TrustInvoice;
import ru.yandex.travel.orders.workflow.invoice.proto.ETrustInvoiceState;
import ru.yandex.travel.orders.workflow.invoice.proto.TPaymentClear;
import ru.yandex.travel.orders.workflow.invoice.proto.TPaymentCompletedWithError;
import ru.yandex.travel.orders.workflow.invoice.proto.TRefreshPaymentStatus;
import ru.yandex.travel.orders.workflow.invoice.proto.TScheduleClearing;
import ru.yandex.travel.orders.workflow.invoice.proto.TTrustInvoiceCallbackReceived;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.IgnoreEvents;

@Slf4j
@Component
@IgnoreEvents(types = {TScheduleClearing.class, TRefreshPaymentStatus.class,
        TPaymentCompletedWithError.class,
        TTrustInvoiceCallbackReceived.class, TPaymentClear.class})
public class TerminalStateHandler extends AnnotatedStatefulWorkflowEventHandler<ETrustInvoiceState, TrustInvoice> {
}
