package ru.yandex.travel.orders.workflows.invoice.trust.jobs;

import java.math.BigDecimal;
import java.time.Duration;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix = "fiscal-receipts", ignoreUnknownFields = false)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Validated
public class FiscalReceiptProperties {
    @NotNull
    private Duration baseRefreshDelay;
    @NotNull
    @DecimalMin("1.0")
    private BigDecimal refreshDelayExponentialFactor;
    @NotNull
    private Duration maxRefreshDelay;
    @Positive
    private int numberOfReceiptsToRefresh;
    @Positive
    private int maxRefreshAttempts;
}
