package ru.yandex.travel.orders.workflows.invoice.trust.jobs;

import java.time.Duration;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import static ru.yandex.misc.lang.ObjectUtils.min;

@Service
@RequiredArgsConstructor
public class FiscalReceiptRefreshDelayService {
    private final FiscalReceiptProperties properties;

    public Duration calculateNextDelay(int attempt) {
        long baseDelay = properties.getBaseRefreshDelay().toNanos();
        double scaleFactor = properties.getRefreshDelayExponentialFactor().doubleValue();
        double scale = Math.pow(scaleFactor, attempt);
        long expDelay = (long) (baseDelay * scale / 2 + (baseDelay * scale * Math.random()));
        return min(Duration.ofNanos(expDelay), properties.getMaxRefreshDelay());
    }
}
