package ru.yandex.travel.orders.workflows.management;

import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.entities.Ticket;
import ru.yandex.travel.orders.management.StarTrekService;
import ru.yandex.travel.orders.workflow.ticket.proto.ETicketState;
import ru.yandex.travel.orders.workflows.management.handlers.CreatedStateHandler;
import ru.yandex.travel.orders.workflows.management.handlers.NewStateHandler;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
@RequiredArgsConstructor
public class TicketWorkflowConfiguration {
    private final StarTrekService starTrekService;

    private final EntityStateTransitionRepository entityStateTransitionRepository;

    @Bean
    public WorkflowEventHandler ticketWorkflowEventHandler() {
        ImmutableMap.Builder<ETicketState, StatefulWorkflowEventHandler<ETicketState, Ticket>> builder =
                ImmutableMap.builder();
        builder.put(ETicketState.TS_NEW, new NewStateHandler(starTrekService));
        builder.put(ETicketState.TS_CREATED, new CreatedStateHandler(starTrekService));
        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }
}
