package ru.yandex.travel.orders.workflows.management.handlers;

import com.google.common.base.Preconditions;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.Ticket;
import ru.yandex.travel.orders.management.StarTrekService;
import ru.yandex.travel.orders.workflow.order.proto.TCommentIssue;
import ru.yandex.travel.orders.workflow.ticket.proto.ETicketState;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@RequiredArgsConstructor
@Slf4j
public class CreatedStateHandler extends AnnotatedStatefulWorkflowEventHandler<ETicketState, Ticket> {
    private final StarTrekService starTrekService;

    @HandleEvent
    public void handleCommentIssue(TCommentIssue event, StateContext<ETicketState, Ticket> messagingContext) {
        Ticket ticket = messagingContext.getWorkflowEntity();
        Preconditions.checkState(ticket.getIssueId() != null, "Ticket key is not set");
        if (event.getCloseIssue()) {
            starTrekService.closeTicket(ticket.getIssueId(), event.getText());
        } else {
            starTrekService.commentIssue(ticket.getIssueId(), event.getText());
        }
    }
}
