package ru.yandex.travel.orders.workflows.management.handlers;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.impl.ArrayListF;
import ru.yandex.travel.orders.entities.Ticket;
import ru.yandex.travel.orders.management.StarTrekService;
import ru.yandex.travel.orders.workflow.order.proto.TCreateIssue;
import ru.yandex.travel.orders.workflow.ticket.proto.ETicketState;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@RequiredArgsConstructor
@Slf4j
public class NewStateHandler extends AnnotatedStatefulWorkflowEventHandler<ETicketState, Ticket> {
    private final StarTrekService starTrekService;

    @HandleEvent
    public void handleCreateIssue(TCreateIssue event, StateContext<ETicketState, Ticket> messagingContext) {
        Ticket ticket = messagingContext.getWorkflowEntity();
        ListF<String> tags = new ArrayListF<>();
        tags.addAll(event.getTagsList());
        String issueId = starTrekService.createIssue(event.getTitle(),
                event.getDescription(),
                event.getQueueName(),
                event.getIssueType(),
                tags);
        ticket.setIssueId(issueId);
        messagingContext.setState(ETicketState.TS_CREATED);
    }
}
