package ru.yandex.travel.orders.workflows.notification;

import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.entities.notifications.Notification;
import ru.yandex.travel.orders.management.StarTrekService;
import ru.yandex.travel.orders.repository.AttachmentRepository;
import ru.yandex.travel.orders.services.MailSenderService;
import ru.yandex.travel.orders.services.YaSmsService;
import ru.yandex.travel.orders.services.cloud.s3.S3Service;
import ru.yandex.travel.orders.services.notifications.NotificationMeters;
import ru.yandex.travel.orders.services.notifications.TemplatedMailSenderService;
import ru.yandex.travel.orders.workflow.notification.proto.ENotificationState;
import ru.yandex.travel.orders.workflows.notification.handlers.NewStateHandler;
import ru.yandex.travel.orders.workflows.notification.handlers.PreparingAttachmentsStateHandler;
import ru.yandex.travel.orders.workflows.notification.handlers.PreparingRequiredAttachmentsStateHandler;
import ru.yandex.travel.orders.workflows.notification.handlers.SendingStateHandler;
import ru.yandex.travel.orders.workflows.notification.handlers.SentStateHandler;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
@RequiredArgsConstructor
public class NotificationWorkflowConfiguration {
    private final AttachmentRepository attachmentRepository;
    private final EntityStateTransitionRepository entityStateTransitionRepository;
    private final MailSenderService mailSenderService;
    private final TemplatedMailSenderService templatedMailSenderService;
    private final StarTrekService starTrekService;
    private final YaSmsService smsSenderService;
    private final S3Service s3Service;
    private final NotificationMeters notificationMeters;

    @Bean
    public WorkflowEventHandler<Notification> notificationWorkflowEventHandler() {
        ImmutableMap.Builder<ENotificationState, StatefulWorkflowEventHandler<ENotificationState, Notification>> builder =
                ImmutableMap.builder();
        builder
                .put(ENotificationState.NS_NEW, new NewStateHandler())
                .put(ENotificationState.NS_PREPARING_ATTACHMENTS,
                        new PreparingAttachmentsStateHandler(attachmentRepository))
                .put(ENotificationState.NS_PREPARING_REQUIRED_ATTACHMENTS,
                        new PreparingRequiredAttachmentsStateHandler(attachmentRepository))
                .put(ENotificationState.NS_SENDING, new SendingStateHandler(mailSenderService,
                        templatedMailSenderService, smsSenderService, starTrekService, s3Service,
                        notificationMeters))
                .put(ENotificationState.NS_SENT, new SentStateHandler());
        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }
}
