package ru.yandex.travel.orders.workflows.notification;

import java.time.Duration;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "notification", ignoreUnknownFields = false)
@Getter
@Setter
@Validated
public class NotificationWorkflowProperties {
    @Positive
    private int preparingExpiredTaskNumberOfItems;
    @NotNull
    private Duration preparingExpiredTaskInitialStartDelay;
    @NotNull
    private Duration preparingExpiredTaskPeriod;
    @NotNull
    private Duration fetchAttachmentRetryDuration;
}
