package ru.yandex.travel.orders.workflows.notification.handlers;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.notifications.Notification;
import ru.yandex.travel.orders.workflow.notification.proto.EAttachmentState;
import ru.yandex.travel.orders.workflow.notification.proto.ENotificationState;
import ru.yandex.travel.orders.workflow.notification.proto.TAttachmentFetchStart;
import ru.yandex.travel.orders.workflow.notification.proto.TSend;
import ru.yandex.travel.orders.workflow.notification.proto.TSendingStart;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
@RequiredArgsConstructor
public class NewStateHandler extends AnnotatedStatefulWorkflowEventHandler<ENotificationState, Notification> {

    @HandleEvent
    public void handlePrepareEmail(TSend event, StateContext<ENotificationState, Notification> context) {
        Notification notification = context.getWorkflowEntity();
        boolean waitingForAttachments = false;

        for (var attachment : notification.getAttachments()) {
            if( attachment.getState() != EAttachmentState.AS_FETCHED ) {
                waitingForAttachments = true;
                context.scheduleExternalEvent(attachment.getWorkflow().getId(),
                        TAttachmentFetchStart.getDefaultInstance());
            }
        }

        if (waitingForAttachments) {
            context.setState(ENotificationState.NS_PREPARING_ATTACHMENTS);
        } else {
            context.setState(ENotificationState.NS_SENDING);
            context.scheduleEvent(TSendingStart.getDefaultInstance());
        }
    }
}
