package ru.yandex.travel.orders.workflows.notification.handlers;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.notifications.Notification;
import ru.yandex.travel.orders.repository.AttachmentRepository;
import ru.yandex.travel.orders.workflow.notification.proto.ENotificationState;
import ru.yandex.travel.orders.workflow.notification.proto.TAttachmentFetched;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.TWorkflowCrashed;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
@RequiredArgsConstructor
public class PreparingRequiredAttachmentsStateHandler extends AnnotatedStatefulWorkflowEventHandler<ENotificationState, Notification> {
    private final AttachmentRepository attachmentRepository;

    @HandleEvent
    public void handleAttachmentFetched(TAttachmentFetched event, StateContext<ENotificationState, Notification> context) {
        PreparingAttachmentsStateHandler.checkAttachmentAndSend(context, true);
    }

    @HandleEvent
    public void handleWorkflowCrashed(TWorkflowCrashed event, StateContext<ENotificationState, Notification> context) {
        PreparingAttachmentsStateHandler.checkTWorkflowCrashed(event, attachmentRepository);
        PreparingAttachmentsStateHandler.checkAttachmentAndSend(context, true);
    }
}
