package ru.yandex.travel.orders.workflows.notification.handlers;


import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.notifications.Notification;
import ru.yandex.travel.orders.workflow.notification.proto.ENotificationState;
import ru.yandex.travel.orders.workflow.notification.proto.TAttachmentFetched;
import ru.yandex.travel.orders.workflow.notification.proto.TPreparingExpired;
import ru.yandex.travel.workflow.TWorkflowCrashed;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.IgnoreEvents;

@Slf4j
@RequiredArgsConstructor
@IgnoreEvents(types = {TAttachmentFetched.class, TPreparingExpired.class, TWorkflowCrashed.class})
public class SentStateHandler extends AnnotatedStatefulWorkflowEventHandler<ENotificationState, Notification> {
}
