package ru.yandex.travel.orders.workflows.order.aeroflot;

import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.entities.AeroflotOrder;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotOrderState;
import ru.yandex.travel.orders.workflows.order.aeroflot.handlers.AeroflotOrderAutoConfirmingInvoiceStateHandler;
import ru.yandex.travel.orders.workflows.order.aeroflot.handlers.AeroflotOrderAutoRestoringInvoiceStateHandler;
import ru.yandex.travel.orders.workflows.order.aeroflot.handlers.AeroflotOrderCancelInvoiceStateHandler;
import ru.yandex.travel.orders.workflows.order.aeroflot.handlers.AeroflotOrderCancelOrderItemStateHandler;
import ru.yandex.travel.orders.workflows.order.aeroflot.handlers.AeroflotOrderCancelledStateHandler;
import ru.yandex.travel.orders.workflows.order.aeroflot.handlers.AeroflotOrderCheckAvailabilityStateHandler;
import ru.yandex.travel.orders.workflows.order.aeroflot.handlers.AeroflotOrderConfirmOrderItemStateHandler;
import ru.yandex.travel.orders.workflows.order.aeroflot.handlers.AeroflotOrderConfirmedStateHandler;
import ru.yandex.travel.orders.workflows.order.aeroflot.handlers.AeroflotOrderConfirmingOrderStateHandler;
import ru.yandex.travel.orders.workflows.order.aeroflot.handlers.AeroflotOrderNewStateHandler;
import ru.yandex.travel.orders.workflows.order.aeroflot.handlers.AeroflotOrderWaitCardTokenizedStateHandler;
import ru.yandex.travel.orders.workflows.order.aeroflot.handlers.AeroflotOrderWaitOrderCreatedStateHandler;
import ru.yandex.travel.orders.workflows.order.aeroflot.handlers.AeroflotOrderWaitOrderPaidStateHandler;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
public class AeroflotOrderWorkflowConfiguration {

    @Autowired
    private EntityStateTransitionRepository entityStateTransitionRepository;

    @Autowired
    private AeroflotOrderNewStateHandler newStateHandler;
    @Autowired
    private AeroflotOrderCheckAvailabilityStateHandler checkAvailabilityHandler;
    @Autowired
    private AeroflotOrderWaitCardTokenizedStateHandler waitCardTokenizedHandler;
    @Autowired
    private AeroflotOrderWaitOrderCreatedStateHandler waitOrderCreatedHandler;
    @Autowired
    private AeroflotOrderWaitOrderPaidStateHandler waitOrderPaidHandler;
    @Autowired
    private AeroflotOrderCancelOrderItemStateHandler cancelOrderItemHandler;
    @Autowired
    private AeroflotOrderCancelInvoiceStateHandler cancelInvoiceHandler;
    @Autowired
    private AeroflotOrderAutoConfirmingInvoiceStateHandler autoConfirmingInvoiceHandler;
    @Autowired
    private AeroflotOrderConfirmOrderItemStateHandler confirmOrderItemHandler;
    @Autowired
    private AeroflotOrderCancelledStateHandler cancelledHandler;
    @Autowired
    private AeroflotOrderAutoRestoringInvoiceStateHandler autoRestoringInvoiceHandler;
    @Autowired
    private AeroflotOrderConfirmingOrderStateHandler confirmOrderHandler;
    @Autowired
    private AeroflotOrderConfirmedStateHandler confirmedOrderHandler;

    @Bean
    public WorkflowEventHandler<?> aeroflotOrderWorkflowEventHandler() {
        return new ProxyStateMapWorkflowEventHandler<>(ImmutableMap
                .<EAeroflotOrderState, StatefulWorkflowEventHandler<EAeroflotOrderState, AeroflotOrder>>builder()
                .put(EAeroflotOrderState.OS_NEW, newStateHandler)
                .put(EAeroflotOrderState.OS_CHECK_AVAILABILITY, checkAvailabilityHandler)
                .put(EAeroflotOrderState.OS_WAIT_CARD_TOKENIZED, waitCardTokenizedHandler)
                .put(EAeroflotOrderState.OS_WAIT_ORDER_CREATED, waitOrderCreatedHandler)
                .put(EAeroflotOrderState.OS_WAIT_ORDER_PAID, waitOrderPaidHandler)
                .put(EAeroflotOrderState.OS_CANCELLING_ORDER_ITEM, cancelOrderItemHandler)
                .put(EAeroflotOrderState.OS_CANCELLING_INVOICE, cancelInvoiceHandler)
                .put(EAeroflotOrderState.OS_AUTO_CONFIRMING_INVOICE, autoConfirmingInvoiceHandler)
                .put(EAeroflotOrderState.OS_CONFIRMING_ORDER_ITEM, confirmOrderItemHandler)
                .put(EAeroflotOrderState.OS_CANCELLED, cancelledHandler)
                .put(EAeroflotOrderState.OS_AUTO_RESTORING_INVOICE, autoRestoringInvoiceHandler)
                .put(EAeroflotOrderState.OS_CONFIRMING_ORDER, confirmOrderHandler)
                .put(EAeroflotOrderState.OS_CONFIRMED, confirmedOrderHandler)
                .build(), entityStateTransitionRepository);
    }
}
