package ru.yandex.travel.orders.workflows.order.aeroflot.handlers;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.AeroflotOrder;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotOrderState;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.TAeroflotInvoiceAutoConfirmed;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.TAeroflotOrderConfirm;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Service
@Slf4j
public class AeroflotOrderAutoConfirmingInvoiceStateHandler
        extends AnnotatedStatefulWorkflowEventHandler<EAeroflotOrderState, AeroflotOrder> {
    @HandleEvent
    public void onConfirmationCompletion(TAeroflotInvoiceAutoConfirmed message,
                                         StateContext<EAeroflotOrderState, AeroflotOrder> ctx) {
        ctx.setState(EAeroflotOrderState.OS_CONFIRMING_ORDER);
        ctx.scheduleEvent(TAeroflotOrderConfirm.newBuilder().build());
    }
}
