package ru.yandex.travel.orders.workflows.order.aeroflot.handlers;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.AeroflotOrder;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotOrderState;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.TAeroflotInvoiceAutoRestored;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.TAeroflotOrderConfirm;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.TAeroflotOrderItemCancelled;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Service
@Slf4j
public class AeroflotOrderAutoRestoringInvoiceStateHandler
        extends AnnotatedStatefulWorkflowEventHandler<EAeroflotOrderState, AeroflotOrder> {
    @HandleEvent
    public void onExternalConfirmationCompleted(TAeroflotInvoiceAutoRestored event,
                                                StateContext<EAeroflotOrderState, AeroflotOrder> ctx) {
        log.info("Cancelled order external confirmation has completed");
        ctx.setState(EAeroflotOrderState.OS_CONFIRMING_ORDER);
        ctx.scheduleEvent(TAeroflotOrderConfirm.newBuilder().build());
    }

    @HandleEvent
    public void onOrderItemCancelled(TAeroflotOrderItemCancelled event,
                                     StateContext<EAeroflotOrderState, AeroflotOrder> ctx) {
        log.info("The order item has been cancelled but we're in process of restoring the order; ignoring the event");
    }
}
