package ru.yandex.travel.orders.workflows.order.aeroflot.handlers;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.AeroflotOrder;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotOrderState;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.TAeroflotInvoiceCancelled;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Service
@Slf4j
public class AeroflotOrderCancelInvoiceStateHandler extends AnnotatedStatefulWorkflowEventHandler<EAeroflotOrderState, AeroflotOrder> {
    @HandleEvent
    public void onCancel(TAeroflotInvoiceCancelled event, StateContext<EAeroflotOrderState, AeroflotOrder> context) {
        context.setState(EAeroflotOrderState.OS_CANCELLED);
    }

    // TAeroflotOrderExternalConfirmationOfCancelled shouldn't happen here as there is no avia_pnr;
    // the order item won't be matched and notified via the TicketsReleased event
}
