package ru.yandex.travel.orders.workflows.order.aeroflot.handlers;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.AeroflotOrder;
import ru.yandex.travel.orders.entities.Invoice;
import ru.yandex.travel.orders.workflow.invoice.aeroflot.proto.TAeroflotInvoiceExternalConfirmationOfCancelled;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotOrderState;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.TAeroflotOrderExternalConfirmationOfCancelled;
import ru.yandex.travel.orders.workflows.order.aeroflot.AeroflotWorkflowUtils;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Service
@Slf4j
public class AeroflotOrderCancelledStateHandler extends AnnotatedStatefulWorkflowEventHandler<EAeroflotOrderState, AeroflotOrder> {
    @HandleEvent
    public void onExternalConfirmation(TAeroflotOrderExternalConfirmationOfCancelled event, StateContext<EAeroflotOrderState, AeroflotOrder> context) {
        // the order item has been restored, let's restore the invoice
        Invoice invoice = AeroflotWorkflowUtils.getOnlyInvoice(context.getWorkflowEntity());
        context.setState(EAeroflotOrderState.OS_AUTO_RESTORING_INVOICE);
        context.scheduleExternalEvent(invoice.getWorkflow().getId(),
                TAeroflotInvoiceExternalConfirmationOfCancelled.newBuilder().build());
    }
}
