package ru.yandex.travel.orders.workflows.order.aeroflot.handlers;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.AeroflotOrder;
import ru.yandex.travel.orders.entities.AeroflotOrderItem;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotOrderState;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.TAeroflotOrderAvailabilityCheckCompleted;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.TAeroflotOrderAvailabilityCheckFailed;
import ru.yandex.travel.orders.workflows.order.aeroflot.AeroflotWorkflowUtils;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Service
@Slf4j
public class AeroflotOrderCheckAvailabilityStateHandler extends AnnotatedStatefulWorkflowEventHandler<EAeroflotOrderState, AeroflotOrder> {
    @HandleEvent
    public void onCheckCompleted(TAeroflotOrderAvailabilityCheckCompleted message, StateContext<EAeroflotOrderState, AeroflotOrder> stateContext) {
        AeroflotOrderItem orderItem = AeroflotWorkflowUtils.getOnlyOrderItem(stateContext.getWorkflowEntity());
        log.info("Availability check has completed: the offer is still available; service.state={}", orderItem.getItemState());
        stateContext.setState(EAeroflotOrderState.OS_WAIT_CARD_TOKENIZED);
    }

    @HandleEvent
    public void onCheckCompleted(TAeroflotOrderAvailabilityCheckFailed message, StateContext<EAeroflotOrderState, AeroflotOrder> stateContext) {
        AeroflotOrderItem orderItem = AeroflotWorkflowUtils.getOnlyOrderItem(stateContext.getWorkflowEntity());
        log.info("Availability check has completed: the offer isn't available anymore, cancelling it; service.state={}", orderItem.getItemState());
        stateContext.setState(EAeroflotOrderState.OS_CANCELLED);
    }
}
