package ru.yandex.travel.orders.workflows.order.aeroflot.handlers;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.AeroflotOrder;
import ru.yandex.travel.orders.services.promo.UserOrderCounterService;
import ru.yandex.travel.orders.services.promo.aeroflotplus.AeroflotPlusPromoService;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotOrderState;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.TAeroflotOrderConfirm;
import ru.yandex.travel.orders.workflows.order.aeroflot.AeroflotWorkflowService;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Service
@RequiredArgsConstructor
@Slf4j
public class AeroflotOrderConfirmingOrderStateHandler
        extends AnnotatedStatefulWorkflowEventHandler<EAeroflotOrderState, AeroflotOrder> {
    private final AeroflotWorkflowService aeroflotWorkflowService;
    private final AeroflotPlusPromoService aeroflotPlusPromoService;
    private final UserOrderCounterService counterService;

    @HandleEvent
    public void onPaymentConfirmed(TAeroflotOrderConfirm event, StateContext<EAeroflotOrderState, AeroflotOrder> ctx) {
        log.info("The order has been confirmed, checking promo campaigns");
        ctx.setState(EAeroflotOrderState.OS_CONFIRMED);
        AeroflotOrder order = ctx.getWorkflowEntity();
        aeroflotWorkflowService.issueHotelPromoCodeOnConfirmation(order);
        aeroflotPlusPromoService.registerConfirmedOrder(order);
        counterService.onOrderConfirmed(order.getId(), order.getDisplayType());
    }
}
