package ru.yandex.travel.orders.workflows.order.aeroflot.handlers;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.AeroflotOrder;
import ru.yandex.travel.orders.entities.Order;
import ru.yandex.travel.orders.entities.OrderItem;
import ru.yandex.travel.orders.proto.TReserveOrderItemReq;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotOrderState;
import ru.yandex.travel.orders.workflow.order.proto.TStartReservation;
import ru.yandex.travel.orders.workflows.order.aeroflot.AeroflotWorkflowUtils;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Service
@Slf4j
public class AeroflotOrderNewStateHandler extends
        AnnotatedStatefulWorkflowEventHandler<EAeroflotOrderState, AeroflotOrder> {
    @HandleEvent
    public void startAvailabilityCheck(TStartReservation message,
                                       StateContext<EAeroflotOrderState, AeroflotOrder> context) {
        Order order = context.getWorkflowEntity();
        OrderItem orderItem = AeroflotWorkflowUtils.getOnlyOrderItem(order);
        log.info("Scheduling an availability check for order_id={}, service_id={}", order.getId(), orderItem.getId());
        context.setState(EAeroflotOrderState.OS_CHECK_AVAILABILITY);
        order.toggleUserActionScheduled(false);
        context.scheduleExternalEvent(orderItem.getWorkflow().getId(), TReserveOrderItemReq.newBuilder().build());
    }
}
