package ru.yandex.travel.orders.workflows.order.aeroflot.handlers;

import java.util.UUID;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.AeroflotOrder;
import ru.yandex.travel.orders.entities.Order;
import ru.yandex.travel.orders.entities.OrderItem;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotOrderState;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.TAeroflotOrderCardTokenizationFailed;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.TAeroflotOrderCardTokenized;
import ru.yandex.travel.orders.workflow.order.proto.TInvoicePaymentStarted;
import ru.yandex.travel.orders.workflow.orderitem.aeroflot.proto.TAeroflotOrderItemCardTokenized;
import ru.yandex.travel.orders.workflow.orderitem.aeroflot.proto.TAeroflotOrderItemTokenizationFailed;
import ru.yandex.travel.orders.workflows.order.aeroflot.AeroflotWorkflowUtils;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Service
@Slf4j
public class AeroflotOrderWaitCardTokenizedStateHandler extends AnnotatedStatefulWorkflowEventHandler<EAeroflotOrderState, AeroflotOrder> {
    @HandleEvent
    public void onEvent(TInvoicePaymentStarted event, StateContext<EAeroflotOrderState, AeroflotOrder> stateContext) {
        Order order = stateContext.getWorkflowEntity();
        log.info("Tokenization has started; order_id={}", order.getId());
    }

    @HandleEvent
    public void onEvent(TAeroflotOrderCardTokenized event, StateContext<EAeroflotOrderState, AeroflotOrder> stateContext) {
        Order order = stateContext.getWorkflowEntity();
        log.info("Payment state has changed; order_id={}", order.getId());

        OrderItem orderItem = AeroflotWorkflowUtils.getOnlyOrderItem(stateContext.getWorkflowEntity());
        stateContext.scheduleExternalEvent(orderItem.getWorkflow().getId(),
                TAeroflotOrderItemCardTokenized.newBuilder()
                        .setTokenizedCard(event.getTokenizedCard())
                        .setDeduplicationKey(UUID.randomUUID().toString())
                        .build());
        stateContext.setState(EAeroflotOrderState.OS_WAIT_ORDER_CREATED);
    }

    @HandleEvent
    public void onEvent(TAeroflotOrderCardTokenizationFailed event, StateContext<EAeroflotOrderState, AeroflotOrder> stateContext) {
        Order order = stateContext.getWorkflowEntity();
        log.info("Tokenization has failed; order_id={}", order.getId());

        OrderItem orderItem = AeroflotWorkflowUtils.getOnlyOrderItem(order);
        stateContext.scheduleExternalEvent(orderItem.getWorkflow().getId(), TAeroflotOrderItemTokenizationFailed.newBuilder().build());
        stateContext.setState(EAeroflotOrderState.OS_CANCELLING_ORDER_ITEM);
    }
}
