package ru.yandex.travel.orders.workflows.order.aeroflot.handlers;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.AeroflotOrder;
import ru.yandex.travel.orders.entities.Invoice;
import ru.yandex.travel.orders.entities.Order;
import ru.yandex.travel.orders.workflow.invoice.aeroflot.proto.TAeroflotInvoiceAutoConfirmation;
import ru.yandex.travel.orders.workflow.invoice.aeroflot.proto.TAeroflotInvoiceOrderCreationFailed;
import ru.yandex.travel.orders.workflow.invoice.aeroflot.proto.TAeroflotInvoicePaymentConfirmation;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotOrderState;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.TAeroflotOrderCreatedAndPaid;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.TAeroflotOrderCreationFailed;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.TAeroflotOrderPaymentConfirmation;
import ru.yandex.travel.orders.workflows.order.aeroflot.AeroflotWorkflowUtils;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Service
@Slf4j
public class AeroflotOrderWaitOrderCreatedStateHandler extends AnnotatedStatefulWorkflowEventHandler<EAeroflotOrderState, AeroflotOrder> {
    @HandleEvent
    public void onEvent(TAeroflotOrderPaymentConfirmation event, StateContext<EAeroflotOrderState, AeroflotOrder> stateContext) {
        Order order = stateContext.getWorkflowEntity();
        Invoice invoice = AeroflotWorkflowUtils.getOnlyInvoice(stateContext.getWorkflowEntity());
        log.info("The confirmation link is ready, starting the invoice workflow; order_id={}, invoice_id={}",
                order.getId(), invoice.getId());

        stateContext.scheduleExternalEvent(invoice.getWorkflow().getId(),
                TAeroflotInvoicePaymentConfirmation.newBuilder().setConfirmationUrl(event.getConfirmationUrl()).build());
        stateContext.setState(EAeroflotOrderState.OS_WAIT_ORDER_PAID);
    }

    @HandleEvent
    public void onCreatedAndPaid(TAeroflotOrderCreatedAndPaid event, StateContext<EAeroflotOrderState, AeroflotOrder> stateContext) {
        Invoice invoice = AeroflotWorkflowUtils.getOnlyInvoice(stateContext.getWorkflowEntity());
        stateContext.setState(EAeroflotOrderState.OS_AUTO_CONFIRMING_INVOICE);
        stateContext.scheduleExternalEvent(invoice.getWorkflow().getId(), TAeroflotInvoiceAutoConfirmation.newBuilder().build());
    }

    @HandleEvent
    public void onCreationFailed(TAeroflotOrderCreationFailed event, StateContext<EAeroflotOrderState, AeroflotOrder> stateContext) {
        Order order = stateContext.getWorkflowEntity();
        log.info("Order creation has failed, stopping the workflow; order_id={}", order.getId());

        Invoice invoice = AeroflotWorkflowUtils.getOnlyInvoice(order);
        stateContext.setState(EAeroflotOrderState.OS_CANCELLING_INVOICE);
        stateContext.scheduleExternalEvent(invoice.getWorkflow().getId(), TAeroflotInvoiceOrderCreationFailed.newBuilder().build());
    }
}
