package ru.yandex.travel.orders.workflows.order.aeroflot.handlers;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.AeroflotOrder;
import ru.yandex.travel.orders.entities.Order;
import ru.yandex.travel.orders.entities.OrderItem;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotOrderState;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.TAeroflotOrderPaymentConfirmationFailed;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.TAeroflotOrderPaymentConfirmed;
import ru.yandex.travel.orders.workflow.orderitem.aeroflot.proto.TAeroflotOrderItemPaymentConfirmationFailed;
import ru.yandex.travel.orders.workflow.orderitem.aeroflot.proto.TAeroflotOrderItemPaymentConfirmed;
import ru.yandex.travel.orders.workflows.order.aeroflot.AeroflotWorkflowUtils;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Service
@Slf4j
public class AeroflotOrderWaitOrderPaidStateHandler extends AnnotatedStatefulWorkflowEventHandler<EAeroflotOrderState, AeroflotOrder> {
    @HandleEvent
    public void onEvent(TAeroflotOrderPaymentConfirmed event, StateContext<EAeroflotOrderState, AeroflotOrder> stateContext) {
        Order order = stateContext.getWorkflowEntity();
        log.info("The order has been paid, confirming it");

        stateContext.setState(EAeroflotOrderState.OS_CONFIRMING_ORDER_ITEM);
        OrderItem orderItem = AeroflotWorkflowUtils.getOnlyOrderItem(order);
        stateContext.scheduleExternalEvent(orderItem.getWorkflow().getId(),
                TAeroflotOrderItemPaymentConfirmed.newBuilder()
                        .setPnr(event.getPnr())
                        .build());
    }

    @HandleEvent
    public void onEvent(TAeroflotOrderPaymentConfirmationFailed event, StateContext<EAeroflotOrderState, AeroflotOrder> stateContext) {
        Order order = stateContext.getWorkflowEntity();
        log.info("The order payment has failed, cancelling the order");

        stateContext.setState(EAeroflotOrderState.OS_CANCELLING_ORDER_ITEM);
        OrderItem orderItem = AeroflotWorkflowUtils.getOnlyOrderItem(order);
        stateContext.scheduleExternalEvent(orderItem.getWorkflow().getId(),
                TAeroflotOrderItemPaymentConfirmationFailed.newBuilder()
                        .setFailed(event.getFailed())
                        .setTimedOut(event.getTimedOut())
                        .build());
    }
}
