package ru.yandex.travel.orders.workflows.order.aeroflot.jobs;

import java.util.UUID;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.services.avia.aeroflot.AeroflotOrderStateSyncProperties;
import ru.yandex.travel.spring.tx.ForcedRollbackTxManagerWrapper;
import ru.yandex.travel.task_processor.RegularTaskKeyProvider;
import ru.yandex.travel.task_processor.TaskProcessor;
import ru.yandex.travel.task_processor.TaskProcessorHelper;

@Configuration
@RequiredArgsConstructor
@EnableConfigurationProperties(AeroflotOrderStateSyncProperties.class)
public class AeroflotOrdersStateSyncTaskProcessorConfiguration {
    private final AeroflotOrdersStateSyncListRefresherTask aeroflotOrdersStateSyncListRefresherTask;
    private final AeroflotOrderStateSyncTask aeroflotOrderStateSyncTask;
    private final ForcedRollbackTxManagerWrapper forcedRollbackTxManagerWrapper;
    private final AeroflotOrderStateSyncProperties config;

    @Bean
    @ConditionalOnProperty(value = {
            "aeroflot-state-sync.enabled",
            "aeroflot-state-sync.orders-list-refresher-task.enabled"
    })
    public TaskProcessor<String> aeroflotOrdersStateSyncListRefresherTaskProcessor() {
        return new TaskProcessor<>(
                new RegularTaskKeyProvider<>(AeroflotOrdersStateSyncListRefresherTask.TASK_KEY),
                aeroflotOrdersStateSyncListRefresherTask::refreshOrdersList,
                forcedRollbackTxManagerWrapper,
                TaskProcessorHelper.createDefaultTxDefinition(config.getOrdersListRefresherTask().getName() + "TxDef"),
                config.getOrdersListRefresherTask()
        );
    }

    @Bean
    @ConditionalOnProperty(value = {
            "aeroflot-state-sync.enabled",
            "aeroflot-state-sync.order-updater-task.enabled"
    })
    public TaskProcessor<UUID> aeroflotOrderStateSyncUpdaterTaskProcessor() {
        return TaskProcessorHelper.simpleTaskProcessor(
                aeroflotOrderStateSyncTask,
                forcedRollbackTxManagerWrapper,
                config.getOrderUpdaterTask()
        );
    }
}
