package ru.yandex.travel.orders.workflows.order.generic;

import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.entities.GenericOrder;
import ru.yandex.travel.orders.management.StarTrekService;
import ru.yandex.travel.orders.repository.MoneyRefundRepository;
import ru.yandex.travel.orders.repository.OrderRefundRepository;
import ru.yandex.travel.orders.repository.VoucherRepository;
import ru.yandex.travel.orders.services.AccountService;
import ru.yandex.travel.orders.services.NotificationHelper;
import ru.yandex.travel.orders.services.buses.BusNotificationHelper;
import ru.yandex.travel.orders.services.finances.FinancialEventService;
import ru.yandex.travel.orders.services.orders.GenericOrderMoneyRefundService;
import ru.yandex.travel.orders.services.orders.RefundPartsService;
import ru.yandex.travel.orders.services.promo.PromoCodeApplicationService;
import ru.yandex.travel.orders.services.promo.UserOrderCounterService;
import ru.yandex.travel.orders.services.promo.mir2020.Mir2020PromoService;
import ru.yandex.travel.orders.services.promo.taxi2020.Taxi2020PromoService;
import ru.yandex.travel.orders.services.suburban.SuburbanNotificationHelper;
import ru.yandex.travel.orders.services.train.TrainRefundLogService;
import ru.yandex.travel.orders.workflow.order.generic.proto.EOrderState;
import ru.yandex.travel.orders.workflows.invoice.trust.jobs.ClearingService;
import ru.yandex.travel.orders.workflows.order.generic.handlers.CancelledStateHandler;
import ru.yandex.travel.orders.workflows.order.generic.handlers.ConfirmedStateHandler;
import ru.yandex.travel.orders.workflows.order.generic.handlers.NewStateHandler;
import ru.yandex.travel.orders.workflows.order.generic.handlers.RefundedStateHandler;
import ru.yandex.travel.orders.workflows.order.generic.handlers.RefundingStateHandler;
import ru.yandex.travel.orders.workflows.order.generic.handlers.ReservedStateHandler;
import ru.yandex.travel.orders.workflows.order.generic.handlers.WaitingCancellationStateHandler;
import ru.yandex.travel.orders.workflows.order.generic.handlers.WaitingConfirmationStateHandler;
import ru.yandex.travel.orders.workflows.order.generic.handlers.WaitingPaymentStateHandler;
import ru.yandex.travel.orders.workflows.order.generic.handlers.WaitingReservationStateHandler;
import ru.yandex.travel.orders.workflows.order.train.TrainWorkflowService;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;
import ru.yandex.travel.workflow.repository.WorkflowRepository;

@Configuration
@RequiredArgsConstructor
@EnableConfigurationProperties({GenericWorkflowProperties.class})
public class GenericOrderWorkflowConfiguration {
    private final AccountService accountService;
    private final EntityStateTransitionRepository entityStateTransitionRepository;
    private final GenericWorkflowProperties genericWorkflowProperties;
    private final FinancialEventService financialEventService;
    private final Taxi2020PromoService taxi2020PromoService;
    private final Mir2020PromoService mir2020PromoService;
    private final VoucherRepository voucherRepository;
    private final WorkflowRepository workflowRepository;
    private final NotificationHelper notificationHelper;
    private final PromoCodeApplicationService promoCodeApplicationService;
    private final SuburbanNotificationHelper suburbanNotificationHelper;
    private final TrainWorkflowService trainWorkflowService;
    private final BusNotificationHelper busNotificationHelper;
    private final UserOrderCounterService userOrderCounterService;
    private final OrderRefundRepository orderRefundRepository;
    private final MoneyRefundRepository moneyRefundRepository;
    private final GenericOrderMoneyRefundService moneyRefundService;
    private final ClearingService clearingService;
    private final TrainRefundLogService trainRefundLogService;
    private final GenericWorkflowService genericWorkflowService;
    private final StarTrekService starTrekService;
    private final RefundPartsService refundPartsService;

    @Bean
    public WorkflowEventHandler<?> genericOrderWorkflowEventHandler() {
        ImmutableMap.Builder<EOrderState, StatefulWorkflowEventHandler<EOrderState, GenericOrder>> builder =
                ImmutableMap.builder();
        builder
                .put(EOrderState.OS_NEW, new NewStateHandler(genericWorkflowProperties))
                .put(EOrderState.OS_WAITING_RESERVATION, new WaitingReservationStateHandler(
                        promoCodeApplicationService, genericWorkflowService))
                .put(EOrderState.OS_RESERVED, new ReservedStateHandler(genericWorkflowService))
                .put(EOrderState.OS_WAITING_PAYMENT, new WaitingPaymentStateHandler(
                        accountService, genericWorkflowService))
                .put(EOrderState.OS_WAITING_CANCELLATION, new WaitingCancellationStateHandler(
                        promoCodeApplicationService))
                .put(EOrderState.OS_WAITING_CONFIRMATION, new WaitingConfirmationStateHandler(
                        financialEventService, taxi2020PromoService, mir2020PromoService, notificationHelper,
                        suburbanNotificationHelper, trainWorkflowService,
                        userOrderCounterService, clearingService))
                .put(EOrderState.OS_CANCELLED, new CancelledStateHandler())
                .put(EOrderState.OS_REFUNDING, new RefundingStateHandler(
                        moneyRefundRepository, moneyRefundService, notificationHelper, busNotificationHelper,
                        trainRefundLogService, starTrekService, genericWorkflowService, userOrderCounterService))
                .put(EOrderState.OS_REFUNDED, new RefundedStateHandler(genericWorkflowService))
                .put(EOrderState.OS_CONFIRMED, new ConfirmedStateHandler(
                        voucherRepository, workflowRepository, orderRefundRepository, genericWorkflowService));
        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }
}
