package ru.yandex.travel.orders.workflows.order.generic;

import java.time.Duration;

import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "generic-workflow", ignoreUnknownFields = false)
@Getter
@Setter
@Validated
public class GenericWorkflowProperties {
    @NotNull
    private Duration orderExpirationTime;
    @NotNull
    private boolean trainRebookingEnabled;
}
