package ru.yandex.travel.orders.workflows.order.generic.handlers;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.GenericOrder;
import ru.yandex.travel.orders.workflow.order.generic.proto.EOrderState;
import ru.yandex.travel.orders.workflow.order.proto.TClearingInProcess;
import ru.yandex.travel.orders.workflow.order.proto.TInvoiceCleared;
import ru.yandex.travel.orders.workflow.order.proto.TInvoicePaymentStarted;
import ru.yandex.travel.orders.workflow.order.proto.TMoneyAcquireErrorOccurred;
import ru.yandex.travel.orders.workflow.order.proto.TMoneyAcquired;
import ru.yandex.travel.orders.workflow.order.proto.TStartReservationCancellation;
import ru.yandex.travel.orders.workflow.orderitem.train.proto.TInsuranceReservationStart;
import ru.yandex.travel.orders.workflows.invoice.trust.InvoiceUtils;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;
import ru.yandex.travel.workflow.base.IgnoreEvents;

@Slf4j
@IgnoreEvents(types = {
        TStartReservationCancellation.class,
        TInvoicePaymentStarted.class,
        TMoneyAcquireErrorOccurred.class,
        TInsuranceReservationStart.class,
        TInvoiceCleared.class,
        TClearingInProcess.class
})
public class CancelledStateHandler extends AnnotatedStatefulWorkflowEventHandler<EOrderState, GenericOrder> {

    @HandleEvent
    public void handleMoneyAcquired(TMoneyAcquired event, StateContext<EOrderState, GenericOrder> ctx){
        GenericOrder order = ctx.getWorkflowEntity();
        order.getStateContext().setMoneyAcquired(true);
        var currentInvoice = order.getCurrentInvoice();
        ctx.setState(EOrderState.OS_WAITING_CANCELLATION);
        ctx.scheduleExternalEvent(currentInvoice.getWorkflow().getId(), InvoiceUtils.buildFullRefund(currentInvoice));
    }
}
