package ru.yandex.travel.orders.workflows.order.hotel;

import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.entities.HotelOrder;
import ru.yandex.travel.orders.management.StarTrekService;
import ru.yandex.travel.orders.repository.VoucherRepository;
import ru.yandex.travel.orders.services.AccountService;
import ru.yandex.travel.orders.services.AuthorizationService;
import ru.yandex.travel.orders.services.NotificationHelper;
import ru.yandex.travel.orders.services.PromoServiceHelper;
import ru.yandex.travel.orders.services.RefundCalculationService;
import ru.yandex.travel.orders.services.finances.FinancialEventService;
import ru.yandex.travel.orders.services.hotels.Meters;
import ru.yandex.travel.orders.services.orders.CheckMoneyRefundsService;
import ru.yandex.travel.orders.services.plus.YandexPlusPromoService;
import ru.yandex.travel.orders.services.promo.PromoCodeApplicationService;
import ru.yandex.travel.orders.services.promo.UserOrderCounterService;
import ru.yandex.travel.orders.services.promo.mir2020.Mir2020PromoService;
import ru.yandex.travel.orders.services.promo.taxi2020.Taxi2020PromoService;
import ru.yandex.travel.orders.workflow.hotels.proto.EHotelOrderState;
import ru.yandex.travel.orders.workflows.order.hotel.handlers.CancelledStateHandler;
import ru.yandex.travel.orders.workflows.order.hotel.handlers.ConfirmedStateHandler;
import ru.yandex.travel.orders.workflows.order.hotel.handlers.ManualProcessingStateHandler;
import ru.yandex.travel.orders.workflows.order.hotel.handlers.NewStateHandler;
import ru.yandex.travel.orders.workflows.order.hotel.handlers.RefundStateHandler;
import ru.yandex.travel.orders.workflows.order.hotel.handlers.WaitingCancellationStateHandler;
import ru.yandex.travel.orders.workflows.order.hotel.handlers.WaitingConfirmationStateHandler;
import ru.yandex.travel.orders.workflows.order.hotel.handlers.WaitingExtraPaymentStateHandler;
import ru.yandex.travel.orders.workflows.order.hotel.handlers.WaitingInvoiceRefundStateHandler;
import ru.yandex.travel.orders.workflows.order.hotel.handlers.WaitingMoneyOnlyRefundStateHandler;
import ru.yandex.travel.orders.workflows.order.hotel.handlers.WaitingPaymentStateHandler;
import ru.yandex.travel.orders.workflows.order.hotel.handlers.WaitingRefundAfterCancellationStateHandler;
import ru.yandex.travel.orders.workflows.order.hotel.handlers.WaitingReservationStateHandler;
import ru.yandex.travel.orders.workflows.order.hotel.handlers.WaitingServiceRefundStateHandler;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowMaintenanceService;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;
import ru.yandex.travel.workflow.repository.WorkflowRepository;

@Configuration
@RequiredArgsConstructor
public class HotelOrderWorkflowConfiguration {
    private final AccountService accountService;
    private final StarTrekService starTrekService;
    private final WorkflowMaintenanceService workflowMaintenanceService;
    private final NotificationHelper notificationHelper;
    private final EntityStateTransitionRepository entityStateTransitionRepository;
    private final VoucherRepository voucherRepository;
    private final WorkflowRepository workflowRepository;
    private final FinancialEventService financialEventService;
    private final CheckMoneyRefundsService checkMoneyRefundsService;
    private final Taxi2020PromoService taxi2020PromoService;
    private final Mir2020PromoService mir2020PromoService;
    private final PromoCodeApplicationService promoCodeApplicationService;
    private final UserOrderCounterService userOrderCounterService;
    private final RefundCalculationService refundCalculationService;
    private final Meters meters;
    private final YandexPlusPromoService yandexPlusPromoService;
    private final PromoServiceHelper promoServiceHelper;
    private final AuthorizationService authorizationService;

    @Bean
    public WorkflowEventHandler<?> hotelOrderWorkflowEventHandler() {
        ImmutableMap.Builder<EHotelOrderState, StatefulWorkflowEventHandler<EHotelOrderState, HotelOrder>> builder =
                ImmutableMap.builder();
        builder
                .put(EHotelOrderState.OS_NEW, new NewStateHandler())
                .put(EHotelOrderState.OS_WAITING_RESERVATION,
                        new WaitingReservationStateHandler(promoCodeApplicationService, promoServiceHelper,
                                authorizationService, userOrderCounterService))
                .put(EHotelOrderState.OS_WAITING_PAYMENT, new WaitingPaymentStateHandler(accountService, meters,
                        promoCodeApplicationService))
                .put(EHotelOrderState.OS_WAITING_CONFIRMATION, new WaitingConfirmationStateHandler(starTrekService,
                        workflowMaintenanceService, financialEventService, taxi2020PromoService, mir2020PromoService,
                        userOrderCounterService, yandexPlusPromoService))
                .put(EHotelOrderState.OS_CONFIRMED,
                        new ConfirmedStateHandler(voucherRepository, workflowRepository, notificationHelper,
                                refundCalculationService, financialEventService))
                .put(EHotelOrderState.OS_WAITING_SERVICE_REFUND,
                        new WaitingServiceRefundStateHandler(financialEventService, promoCodeApplicationService,
                                userOrderCounterService))
                .put(EHotelOrderState.OS_WAITING_INVOICE_REFUND,
                        new WaitingInvoiceRefundStateHandler(notificationHelper))
                .put(EHotelOrderState.OS_REFUNDED, new RefundStateHandler(checkMoneyRefundsService,
                        financialEventService))
                .put(EHotelOrderState.OS_WAITING_CANCELLATION,
                        new WaitingCancellationStateHandler(promoCodeApplicationService))
                .put(EHotelOrderState.OS_WAITING_REFUND_AFTER_CANCELLATION,
                        new WaitingRefundAfterCancellationStateHandler(promoCodeApplicationService))
                .put(EHotelOrderState.OS_CANCELLED, new CancelledStateHandler())
                .put(EHotelOrderState.OS_MANUAL_PROCESSING, new ManualProcessingStateHandler(checkMoneyRefundsService))
                .put(EHotelOrderState.OS_WAITING_EXTRA_PAYMENT, new WaitingExtraPaymentStateHandler(accountService,
                        financialEventService))
                .put(EHotelOrderState.OS_WAITING_MONEY_ONLY_REFUND, new WaitingMoneyOnlyRefundStateHandler());
        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }
}
