package ru.yandex.travel.orders.workflows.order.hotel;

import java.time.Duration;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "hotel-workflow", ignoreUnknownFields = false)
@Getter
@Setter
@Validated
public class HotelWorkflowProperties {
    @NotNull
    private TaskProcessorProperties checkExpirationTask;
    @NotNull
    private MailProperties mail;

    @Getter
    @Setter
    @Validated
    public static class MailProperties {
        @NotEmpty
        private String orderUrlBase;
        @NotEmpty
        private String orderConfirmedCampaign;
        @NotEmpty
        private String orderRefundedCampaign;
        @NotEmpty
        private String orderRequiresPaymentCampaign;
        @NotEmpty
        private String paymentUrlBase;
        @NotNull
        private Duration preparingAttachmentsTime;

        private boolean useTemplatedMailSenderService;
        private String orderConfirmedTemplate;
        private String orderRefundedTemplate;

        private String moscowPhone;
        private String russiaPhone;
        private String globalPhone;
    }

    @Getter
    @Setter
    @Validated
    public static class TaskProcessorProperties {
        @NotNull
        private boolean enabled;
        @NotNull
        private Duration initialStartDelay;
        @NotNull
        private Duration period;
        @Positive
        private int numberOfItems;
    }
}
