package ru.yandex.travel.orders.workflows.order.hotel.handlers;

import ru.yandex.travel.orders.entities.HotelOrder;
import ru.yandex.travel.orders.workflow.hotels.proto.EHotelOrderState;
import ru.yandex.travel.orders.workflow.voucher.proto.EVoucherType;
import ru.yandex.travel.workflow.StateContext;

public class HotelHandlerCommon {
    public static void handleDocumentCreated(EVoucherType docType, String docUrl, StateContext<EHotelOrderState, HotelOrder> context) {
        HotelOrder order = context.getWorkflowEntity();
        if (docType == EVoucherType.VT_HOTELS || docType == EVoucherType.VT_UNKNOWN) {
            order.setDocumentUrl(docUrl);
        } else if (docType == EVoucherType.VT_HOTELS_BUSINESS_TRIP) {
            order.setBusinessTripDocUrl(docUrl);
        }
    }
}
