package ru.yandex.travel.orders.workflows.order.hotel.handlers;

import ru.yandex.travel.orders.entities.HotelOrder;
import ru.yandex.travel.orders.entities.OrderItem;
import ru.yandex.travel.orders.workflow.hotels.proto.EHotelOrderState;
import ru.yandex.travel.orders.workflow.hotels.proto.TReservationStart;
import ru.yandex.travel.orders.workflow.order.proto.TStartReservation;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

public class NewStateHandler extends AnnotatedStatefulWorkflowEventHandler<EHotelOrderState, HotelOrder> {
    @HandleEvent
    public void handleStartReservation(TStartReservation event, StateContext<EHotelOrderState, HotelOrder> context) {
        HotelOrder order = context.getWorkflowEntity();
        for (OrderItem item : order.getOrderItems()) {
            context.scheduleExternalEvent(item.getWorkflow().getId(), TReservationStart.newBuilder().build());
        }
        context.setState(EHotelOrderState.OS_WAITING_RESERVATION);
        order.toggleUserActionScheduled(false);
    }
}
