package ru.yandex.travel.orders.workflows.order.hotel.handlers;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.HotelOrder;
import ru.yandex.travel.orders.entities.MoneyRefund;
import ru.yandex.travel.orders.entities.MoneyRefundState;
import ru.yandex.travel.orders.services.NotificationHelper;
import ru.yandex.travel.orders.workflow.hotels.proto.EHotelOrderState;
import ru.yandex.travel.orders.workflow.notification.proto.TNotificationComplete;
import ru.yandex.travel.orders.workflow.notification.proto.TSend;
import ru.yandex.travel.orders.workflow.order.proto.TClearingInProcess;
import ru.yandex.travel.orders.workflow.order.proto.TInvoiceCleared;
import ru.yandex.travel.orders.workflow.order.proto.TInvoiceNotRefunded;
import ru.yandex.travel.orders.workflow.order.proto.TInvoicePaymentStarted;
import ru.yandex.travel.orders.workflow.order.proto.TPaymentCanNotBeCancelled;
import ru.yandex.travel.orders.workflow.order.proto.TPaymentCancelled;
import ru.yandex.travel.orders.workflow.order.proto.TStartInvoiceRefund;
import ru.yandex.travel.orders.workflow.voucher.proto.TVoucherCreated;
import ru.yandex.travel.orders.workflow.voucher.proto.TVoucherRecreated;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;
import ru.yandex.travel.workflow.base.IgnoreEvents;

@Slf4j
//TODO (mbobrov): revalidate this list when spec is updated
@IgnoreEvents(types = {
        TInvoicePaymentStarted.class,
        TClearingInProcess.class,
        TInvoiceCleared.class,
        TVoucherCreated.class,
        TVoucherRecreated.class,
        TPaymentCancelled.class,
        TPaymentCanNotBeCancelled.class,
})
@RequiredArgsConstructor
public class WaitingInvoiceRefundStateHandler extends BaseWaitingMoneyRefundStateHandler {
    private final NotificationHelper notificationHelper;

    protected void finishRefund(MoneyRefund refund, StateContext<EHotelOrderState, HotelOrder> ctx) {
        ctx.setState(EHotelOrderState.OS_REFUNDED);
        var emailWorkflowId = notificationHelper.createWorkflowForRefundHotelNotification(ctx.getWorkflowEntity());
        ctx.scheduleExternalEvent(emailWorkflowId, TSend.newBuilder().build());
        refund.setState(MoneyRefundState.REFUNDED);
    }

    @Override
    protected String getMoneyRefundReason(TStartInvoiceRefund event) {
        return "Cancelling the order";
    }

    @HandleEvent
    public void handleInvoiceRefundFailed(TInvoiceNotRefunded event,
                                          StateContext<EHotelOrderState, HotelOrder> context) {
        // TODO (mbobrov): here we can't get the breakdown
        throw new RuntimeException("Invoice refund failed");
//        context.scheduleEvent(TStartInvoiceRefund.newBuilder().build());
    }

    @HandleEvent
    public void handleNotificationComplete(TNotificationComplete event,
                                           StateContext<EHotelOrderState, HotelOrder> context) {
        log.info("Confirmation notification sent for order {}", context.getWorkflowEntity().getId());
    }
}
