package ru.yandex.travel.orders.workflows.order.hotel.handlers;

import com.google.common.base.Preconditions;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.HotelOrder;
import ru.yandex.travel.orders.entities.MoneyRefund;
import ru.yandex.travel.orders.entities.MoneyRefundState;
import ru.yandex.travel.orders.workflow.hotels.proto.EHotelOrderState;
import ru.yandex.travel.orders.workflow.order.proto.TStartInvoiceRefund;
import ru.yandex.travel.workflow.StateContext;

@RequiredArgsConstructor
@Slf4j
public class WaitingMoneyOnlyRefundStateHandler extends BaseWaitingMoneyRefundStateHandler {
    protected void finishRefund(MoneyRefund refund, StateContext<EHotelOrderState, HotelOrder> ctx) {
        Preconditions.checkState(refund.getContext().getTargetHotelOrderState() != EHotelOrderState.OS_UNKNOWN,
                "Target hotel order state is required for money only refund");
        ctx.setState(refund.getContext().getTargetHotelOrderState());
        refund.setState(MoneyRefundState.REFUNDED);
    }

    @Override
    protected String getMoneyRefundReason(TStartInvoiceRefund event) {
        return event.getReason().length() != 0 ? event.getReason() : "Refunding money of the order";
    }
}
