package ru.yandex.travel.orders.workflows.order.hotel.handlers;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.HotelOrder;
import ru.yandex.travel.orders.entities.TrustInvoice;
import ru.yandex.travel.orders.services.promo.PromoCodeApplicationService;
import ru.yandex.travel.orders.workflow.hotels.proto.EHotelOrderState;
import ru.yandex.travel.orders.workflow.order.proto.TClearingInProcess;
import ru.yandex.travel.orders.workflow.order.proto.TInvoiceCleared;
import ru.yandex.travel.orders.workflow.order.proto.TInvoicePaymentStarted;
import ru.yandex.travel.orders.workflow.order.proto.TInvoiceRefunded;
import ru.yandex.travel.orders.workflow.order.proto.TMoneyAcquireErrorOccurred;
import ru.yandex.travel.orders.workflow.order.proto.TMoneyAcquired;
import ru.yandex.travel.orders.workflow.order.proto.TStartReservationCancellation;
import ru.yandex.travel.orders.workflows.invoice.trust.InvoiceUtils;
import ru.yandex.travel.orders.workflows.order.OrderUtils;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;
import ru.yandex.travel.workflow.base.IgnoreEvents;

@Slf4j
@RequiredArgsConstructor
@IgnoreEvents(types = {
        TInvoiceCleared.class,
        TInvoicePaymentStarted.class,
        TStartReservationCancellation.class,
        TClearingInProcess.class,
})
public class WaitingRefundAfterCancellationStateHandler extends AnnotatedStatefulWorkflowEventHandler<EHotelOrderState, HotelOrder> {

    private final PromoCodeApplicationService promoCodeApplicationService;

    @HandleEvent
    public void handleMoneyAcquired(TMoneyAcquired event, StateContext<EHotelOrderState, HotelOrder> ctx) {
        HotelOrder order = ctx.getWorkflowEntity();
        TrustInvoice invoice = OrderUtils.getRequiredCurrentInvoice(order);
        ctx.scheduleExternalEvent(invoice.getWorkflow().getId(), InvoiceUtils.buildFullRefund(invoice));
    }

    @HandleEvent
    public void handleInvoiceRefunded(TInvoiceRefunded event, StateContext<EHotelOrderState, HotelOrder> ctx) {
        promoCodeApplicationService.freePromoCodeActivations(ctx.getWorkflowEntity());
        ctx.setState(EHotelOrderState.OS_CANCELLED);
    }

    @HandleEvent
    public void handleMoneyAcquireErrorOccurred(TMoneyAcquireErrorOccurred event, StateContext<EHotelOrderState,
            HotelOrder> ctx) {
        promoCodeApplicationService.freePromoCodeActivations(ctx.getWorkflowEntity());
        ctx.setState(EHotelOrderState.OS_CANCELLED);
    }
}
