package ru.yandex.travel.orders.workflows.order.train.handlers;

import com.google.common.base.Preconditions;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.TrainOrder;
import ru.yandex.travel.orders.entities.TrainOrderItem;
import ru.yandex.travel.orders.workflow.order.proto.TStartReservation;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.TReservationStart;
import ru.yandex.travel.orders.workflow.train.proto.ETrainOrderState;
import ru.yandex.travel.orders.workflows.orderitem.train.TrainWorkflowProperties;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
@RequiredArgsConstructor
public class NewStateHandler extends AnnotatedStatefulWorkflowEventHandler<ETrainOrderState, TrainOrder> {
    private final TrainWorkflowProperties trainWorkflowProperties;

    @HandleEvent
    public void handleStartReservation(TStartReservation event, StateContext<ETrainOrderState, TrainOrder> context) {
        TrainOrder order = context.getWorkflowEntity();
        TrainOrderItem orderItem = (TrainOrderItem) order.getOrderItems().get(0);
        order.setTrainRebookingEnabled(trainWorkflowProperties.isRebookingEnabled() && !orderItem.getPayload().isProviderP2());
        order.setExpiresAt(order.getCreatedAt().plus(trainWorkflowProperties.getOrderExpirationTime()));
        Preconditions.checkState(order.getOrderItems().size() == 1, "Train order can work only with one order item");
        context.scheduleExternalEvent(order.getOrderItems().get(0).getWorkflow().getId(),
                TReservationStart.newBuilder().build());

        context.setState(ETrainOrderState.OS_WAITING_RESERVATION);
        order.toggleUserActionScheduled(false);
    }
}
