package ru.yandex.travel.orders.workflows.order.train.handlers;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.TrainOrder;
import ru.yandex.travel.orders.entities.TrustInvoice;
import ru.yandex.travel.orders.workflow.order.proto.TInvoicePaymentStarted;
import ru.yandex.travel.orders.workflow.order.proto.TInvoiceRefunded;
import ru.yandex.travel.orders.workflow.order.proto.TMoneyAcquireErrorOccurred;
import ru.yandex.travel.orders.workflow.order.proto.TMoneyAcquired;
import ru.yandex.travel.orders.workflow.train.proto.ETrainOrderState;
import ru.yandex.travel.orders.workflows.invoice.trust.InvoiceUtils;
import ru.yandex.travel.orders.workflows.order.OrderUtils;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;
import ru.yandex.travel.workflow.base.IgnoreEvents;

@Slf4j
@IgnoreEvents(types = {
        TInvoicePaymentStarted.class,
        ru.yandex.travel.orders.workflow.train.proto.TStartReservationCancellation.class,
        ru.yandex.travel.orders.workflow.order.proto.TStartReservationCancellation.class
})
public class WaitingRefundAfterCancellationStateHandler
        extends AnnotatedStatefulWorkflowEventHandler<ETrainOrderState, TrainOrder> {

    @HandleEvent
    public void handleMoneyAcquired(TMoneyAcquired event, StateContext<ETrainOrderState, TrainOrder> ctx) {
        TrainOrder order = ctx.getWorkflowEntity();
        order.setMoneyAcquired(true);
        TrustInvoice invoice = OrderUtils.getRequiredCurrentInvoice(order);
        ctx.scheduleExternalEvent(invoice.getWorkflow().getId(), InvoiceUtils.buildFullRefund(invoice));
    }

    @HandleEvent
    public void handleInvoiceRefunded(TInvoiceRefunded event, StateContext<ETrainOrderState, TrainOrder> ctx) {
        ctx.setState(ETrainOrderState.OS_CANCELLED);
    }

    @HandleEvent
    public void handleMoneyAcquireErrorOccurred(TMoneyAcquireErrorOccurred event,
                                                StateContext<ETrainOrderState, TrainOrder> ctx) {
        ctx.setState(ETrainOrderState.OS_CANCELLED);
    }
}
