package ru.yandex.travel.orders.workflows.orderitem;

import java.util.Collection;

import ru.yandex.travel.orders.entities.FiscalItem;
import ru.yandex.travel.orders.entities.OrderItem;

public interface FiscalItemCreator<T extends OrderItem> {
    Collection<FiscalItem> createFiscalItems(T orderItem);

    default void addFiscalItems(T orderItem) {
        if (!orderItem.isPostPaid())
            createFiscalItems(orderItem).forEach(orderItem::addFiscalItem);
    }
}
