package ru.yandex.travel.orders.workflows.orderitem.aeroflot.configuration;

import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.entities.AeroflotOrderItem;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotItemState;
import ru.yandex.travel.orders.workflows.orderitem.aeroflot.handlers.AeroflotOrderItemCancelledStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.aeroflot.handlers.AeroflotOrderItemCheckAvailabilityFailedStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.aeroflot.handlers.AeroflotOrderItemCheckAvailabilityStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.aeroflot.handlers.AeroflotOrderItemConfirmedStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.aeroflot.handlers.AeroflotOrderItemCreateOrderFailedStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.aeroflot.handlers.AeroflotOrderItemExternallyConfirmedStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.aeroflot.handlers.AeroflotOrderItemNewStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.aeroflot.handlers.AeroflotOrderItemWaitConfirmationStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.aeroflot.handlers.AeroflotOrderItemWaitTokenizationStateHandler;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
@EnableConfigurationProperties(AeroflotWorkflowProperties.class)
public class AeroflotOrderItemWorkflowConfiguration {

    @Autowired
    private EntityStateTransitionRepository entityStateTransitionRepository;

    @Autowired
    private AeroflotOrderItemNewStateHandler newStateHandler;
    @Autowired
    private AeroflotOrderItemCheckAvailabilityStateHandler checkAvailabilityHandler;
    @Autowired
    private AeroflotOrderItemCheckAvailabilityFailedStateHandler checkAvailabilityFailedHandler;
    @Autowired
    private AeroflotOrderItemWaitTokenizationStateHandler waitTokenizationHandler;
    @Autowired
    private AeroflotOrderItemCreateOrderFailedStateHandler createOrderFailedStateHandler;
    @Autowired
    private AeroflotOrderItemWaitConfirmationStateHandler waitConfirmationHandler;
    @Autowired
    private AeroflotOrderItemExternallyConfirmedStateHandler externallyConfirmedHandler;
    @Autowired
    private AeroflotOrderItemConfirmedStateHandler confirmedHandler;
    @Autowired
    private AeroflotOrderItemCancelledStateHandler cancelledHandler;

    @Bean
    public WorkflowEventHandler aeroflotServiceWorkflowEventHandler() {
        return new ProxyStateMapWorkflowEventHandler<>(ImmutableMap
                .<EAeroflotItemState, StatefulWorkflowEventHandler<EAeroflotItemState, AeroflotOrderItem>>builder()
                .put(EAeroflotItemState.IS_NEW, newStateHandler)
                .put(EAeroflotItemState.IS_CHECK_AVAILABILITY, checkAvailabilityHandler)
                .put(EAeroflotItemState.IS_CHECK_AVAILABILITY_FAILED, checkAvailabilityFailedHandler)
                .put(EAeroflotItemState.IS_WAIT_TOKENIZATION, waitTokenizationHandler)
                .put(EAeroflotItemState.IS_CREATE_ORDER_NOT_AVAILABLE, createOrderFailedStateHandler)
                .put(EAeroflotItemState.IS_PRICE_CHANGED, createOrderFailedStateHandler)
                .put(EAeroflotItemState.IS_WAIT_CONFIRMATION, waitConfirmationHandler)
                .put(EAeroflotItemState.IS_EXTERNALLY_CONFIRMED, externallyConfirmedHandler)
                .put(EAeroflotItemState.IS_CONFIRMED, confirmedHandler)
                .put(EAeroflotItemState.IS_CANCELLED, cancelledHandler)
                .build(), entityStateTransitionRepository);
    }
}
