package ru.yandex.travel.orders.workflows.orderitem.aeroflot.configuration;

import java.time.Duration;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "aeroflot-workflow", ignoreUnknownFields = false)
@Getter
@Setter
@Validated
public class AeroflotWorkflowProperties {
    @NotNull
    private Long billingClientId;

    @NotNull
    private Duration invoiceTrustTimeout;
    @NotNull
    private Duration invoiceTrustRefreshTimeout;
    @NotNull
    private Duration invoiceTrustErrorRefreshTimeout;

    @NotNull
    private Duration invoiceConfirmationTimeout;
    @NotNull
    private Duration invoiceConfirmationRefreshTimeout;
    @NotNull
    private Duration invoiceConfirmationErrorRefreshTimeout;

    @NotNull
    private Integer maxRefreshTokenization;
    @NotNull
    private Integer maxRefreshConfirmation;

    @NotNull
    private Duration invoiceAwaitingTokenizationRefreshInitialDelay;
    @NotNull
    private Duration invoiceAwaitingTokenizationRefreshRate;
    @NotNull
    private Duration invoiceAwaitingConfirmationRefreshInitialDelay;
    @NotNull
    private Duration invoiceAwaitingConfirmationRefreshRate;

    @NotNull
    private PromoProperties promo;

    @Getter
    @Setter
    @Validated
    public static class PromoProperties {
        @NotNull
        private Boolean enabled;
        @NotNull
        private Duration delay;
        @NotEmpty
        private String campaign;

        private String commonPromoCodeForHotels;
        private String promoActionForHotels;
        private boolean generatePersonalPromoCodes;
    }
}
