package ru.yandex.travel.orders.workflows.orderitem.aeroflot.handlers;

import java.time.Instant;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.avia.booking.partners.gateways.aeroflot.model.AeroflotServicePayload;
import ru.yandex.travel.orders.entities.AeroflotOrderItem;
import ru.yandex.travel.orders.management.StarTrekService;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotItemState;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.TAeroflotOrderExternalConfirmationOfCancelled;
import ru.yandex.travel.orders.workflow.orderitem.aeroflot.proto.TAeroflotOrderItemTicketsReleased;
import ru.yandex.travel.orders.workflows.order.aeroflot.AeroflotWorkflowUtils;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Service
@RequiredArgsConstructor
@Slf4j
public class AeroflotOrderItemCancelledStateHandler extends AnnotatedStatefulWorkflowEventHandler<EAeroflotItemState,
        AeroflotOrderItem> {
    private final StarTrekService starTrekService;

    @HandleEvent
    public void onTicketsReleased(TAeroflotOrderItemTicketsReleased event, StateContext<EAeroflotItemState,
            AeroflotOrderItem> ctx) {
        log.info("The cancelled order was paid and ticketed in fact; restoring it");

        AeroflotOrderItem orderItem = ctx.getWorkflowEntity();
        AeroflotServicePayload payload = orderItem.getPayload();
        AeroflotWorkflowUtils.updateTickets(payload, event.getTicketsList());
        orderItem.setPayload(payload);

        // disabled according to TRAVELBACK-637
        //starTrekService.createIssueForAeroflotCancelledOrderPaid(orderItem.getOrder(), event.getOwnerLastName(), ctx);

        ctx.getWorkflowEntity().setConfirmedAt(Instant.now());
        ctx.setState(EAeroflotItemState.IS_CONFIRMED);
        ctx.scheduleExternalEvent(ctx.getWorkflowEntity().getOrderWorkflowId(),
                TAeroflotOrderExternalConfirmationOfCancelled.newBuilder().build());
    }
}
