package ru.yandex.travel.orders.workflows.orderitem.aeroflot.handlers;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.avia.booking.partners.gateways.aeroflot.model.AeroflotServicePayload;
import ru.yandex.travel.orders.entities.AeroflotOrderItem;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotItemState;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.TAeroflotOrderExternalCancelled;
import ru.yandex.travel.orders.workflow.orderitem.aeroflot.proto.TAeroflotOrderItemCouponRefresh;
import ru.yandex.travel.orders.workflow.orderitem.aeroflot.proto.TAeroflotOrderItemTicketsReleased;
import ru.yandex.travel.orders.workflows.order.aeroflot.AeroflotWorkflowUtils;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Service
@Slf4j
public class AeroflotOrderItemConfirmedStateHandler extends AnnotatedStatefulWorkflowEventHandler<EAeroflotItemState, AeroflotOrderItem> {
    @HandleEvent
    public void onTicketsReleased(TAeroflotOrderItemTicketsReleased event, StateContext<EAeroflotItemState, AeroflotOrderItem> stateContext) {
        log.info("Assigning the confirmed tickets; tickets={}", event.getTicketsList());
        AeroflotOrderItem orderItem = stateContext.getWorkflowEntity();
        AeroflotServicePayload payload = orderItem.getPayload();
        AeroflotWorkflowUtils.updateTickets(payload, event.getTicketsList());
        orderItem.setPayload(payload);
    }

    @HandleEvent
    public void onExternalCouponRefresh(TAeroflotOrderItemCouponRefresh event, StateContext<EAeroflotItemState,
            AeroflotOrderItem> ctx) {
        log.info("External coupon refresh");

        AeroflotOrderItem orderItem = ctx.getWorkflowEntity();
        AeroflotServicePayload payload = orderItem.getPayload();

        AeroflotWorkflowUtils.updateTicketCoupons(payload, event.getTicketCouponsMap());
        orderItem.setPayload(payload);

        if (event.getCancel()) {
            log.info("External cancel");
            ctx.setState(EAeroflotItemState.IS_CANCELLED);
            ctx.scheduleExternalEvent(orderItem.getOrderWorkflowId(), TAeroflotOrderExternalCancelled.newBuilder().build());
        }
    }
}
