package ru.yandex.travel.orders.workflows.orderitem.aeroflot.handlers;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.AeroflotOrderItem;
import ru.yandex.travel.orders.proto.TReserveOrderItemReq;
import ru.yandex.travel.orders.services.partners.BillingPartnerService;
import ru.yandex.travel.orders.workflow.order.aeroflot.proto.EAeroflotItemState;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.AnnotatedStatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.base.HandleEvent;

@Service
@RequiredArgsConstructor
@Slf4j
public class AeroflotOrderItemNewStateHandler extends AnnotatedStatefulWorkflowEventHandler<EAeroflotItemState, AeroflotOrderItem> {
    private final BillingPartnerService billingPartnerService;

    @HandleEvent
    public void onStartReservation(TReserveOrderItemReq event, StateContext<EAeroflotItemState, AeroflotOrderItem> stateContext) {
        log.info("Starting availability check; orderItem.id={}", stateContext.getWorkflowEntity().getId());
        billingPartnerService.addAgreementOrThrow(stateContext.getWorkflowEntity());
        stateContext.setState(EAeroflotItemState.IS_CHECK_AVAILABILITY);
        stateContext.scheduleEvent(event);
    }
}
