package ru.yandex.travel.orders.workflows.orderitem.aeroflot.mq;

import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.entities.AeroflotMqMessage;
import ru.yandex.travel.orders.workflow.orderitem.aeroflot.mq.proto.EAeroflotMqMessageState;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
@RequiredArgsConstructor
public class AeroflotMqWorkflowConfiguration {
    private final AeroflotMqMessageNewStateHandler aeroflotMqMessageNewStateHandler;
    private final EntityStateTransitionRepository entityStateTransitionRepository;

    @Bean
    public WorkflowEventHandler aeroflotMqMessageWorkflowEventHandler() {
        ImmutableMap.Builder<EAeroflotMqMessageState, StatefulWorkflowEventHandler<EAeroflotMqMessageState, AeroflotMqMessage>> builder =
                ImmutableMap.builder();
        builder.put(EAeroflotMqMessageState.MS_NEW, aeroflotMqMessageNewStateHandler);
        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }
}
