package ru.yandex.travel.orders.workflows.orderitem.bnovo;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.commons.retry.Retry;
import ru.yandex.travel.hotels.common.partners.bnovo.BNovoClient;
import ru.yandex.travel.hotels.common.partners.bnovo.DefaultBNovoClient;

@Configuration
@EnableConfigurationProperties(BNovoConfigurationProperties.class)
public class BNovoConfiguration {
    @Bean
    public BNovoClient bNovoClient(AsyncHttpClientWrapper bNovoAhcClientWrapper,
                                   BNovoConfigurationProperties properties,
                                   Retry retryHelper) {
        return new DefaultBNovoClient(bNovoAhcClientWrapper, properties.getClient(), retryHelper);
    }
}
