package ru.yandex.travel.orders.workflows.orderitem.bnovo;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.hotels.common.partners.bnovo.BNovoClientProperties;

@ConfigurationProperties(value = "bnovo", ignoreUnknownFields = false)
@Getter
@Setter
@Validated
public class BNovoConfigurationProperties {
    @NotNull
    private Integer maxDuplicatePollingAttempts;

    @NotNull
    @Valid
    private BNovoClientProperties client;

    @NotNull
    @Valid
    private BillingProperties billing;

    @Getter
    @Setter
    @Validated
    public static class BillingProperties {
        @NotEmpty
        private String fiscalTitle;

        @NotEmpty
        private String mealFiscalTitle;

        private boolean generateMealItems;
    }
}
