package ru.yandex.travel.orders.workflows.orderitem.bnovo;

import com.google.common.collect.ImmutableMap;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.common.partners.bnovo.BNovoClient;
import ru.yandex.travel.orders.cache.BalanceContractDictionary;
import ru.yandex.travel.orders.entities.BNovoOrderItem;
import ru.yandex.travel.orders.services.finances.FinancialEventService;
import ru.yandex.travel.orders.services.hotels.Meters;
import ru.yandex.travel.orders.services.partners.BillingPartnerService;
import ru.yandex.travel.orders.workflow.hotels.bnovo.proto.EBNovoItemState;
import ru.yandex.travel.orders.workflows.orderitem.bnovo.handlers.CancelledStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.bnovo.handlers.CancellingStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.bnovo.handlers.ConfirmedStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.bnovo.handlers.ConfirmingStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.bnovo.handlers.NewStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.bnovo.handlers.PollingStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.bnovo.handlers.RefundingStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.bnovo.handlers.ReservedStateHandler;
import ru.yandex.travel.orders.workflows.orderitem.bnovo.handlers.ReservingStateHandler;
import ru.yandex.travel.workflow.StatefulWorkflowEventHandler;
import ru.yandex.travel.workflow.WorkflowEventHandler;
import ru.yandex.travel.workflow.base.ProxyStateMapWorkflowEventHandler;
import ru.yandex.travel.workflow.repository.EntityStateTransitionRepository;

@Configuration
@RequiredArgsConstructor
public class BNovoWorkflowConfiguration {
    private final BNovoClient bNovoClient;
    private final BNovoConfigurationProperties properties;
    private final EntityStateTransitionRepository entityStateTransitionRepository;
    private final BillingPartnerService billingPartnerService;
    private final BalanceContractDictionary balanceContractDictionary;
    private final FinancialEventService financialEventService;
    private final Meters meters;

    @Bean
    public WorkflowEventHandler<BNovoOrderItem> bNovoOrderItemWorkflowEventHandler() {
        ImmutableMap.Builder<EBNovoItemState, StatefulWorkflowEventHandler<EBNovoItemState,
                BNovoOrderItem>> builder = ImmutableMap.builder();
        builder
                .put(EBNovoItemState.IS_NEW, new NewStateHandler(meters, billingPartnerService, properties))
                .put(EBNovoItemState.IS_RESERVING, new ReservingStateHandler(bNovoClient, meters, properties))
                .put(EBNovoItemState.IS_RESERVED, new ReservedStateHandler(meters, properties))
                .put(EBNovoItemState.IS_CANCELLING, new CancellingStateHandler(bNovoClient, meters, properties))
                .put(EBNovoItemState.IS_CONFIRMING, new ConfirmingStateHandler(bNovoClient, meters, properties))
                .put(EBNovoItemState.IS_CONFIRMED, new ConfirmedStateHandler(meters, properties,
                        financialEventService, billingPartnerService))
                .put(EBNovoItemState.IS_REFUNDING, new RefundingStateHandler(bNovoClient, meters, properties))
                .put(EBNovoItemState.IS_CANCELLED, new CancelledStateHandler(meters, properties))
                .put(EBNovoItemState.IS_POLLING_FOR_DUPLICATES, new PollingStateHandler(bNovoClient, meters,
                        properties));

        return new ProxyStateMapWorkflowEventHandler<>(builder.build(), entityStateTransitionRepository);
    }
}
