package ru.yandex.travel.orders.workflows.orderitem.bnovo;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.orders.entities.BNovoOrderItem;
import ru.yandex.travel.orders.entities.FiscalItem;
import ru.yandex.travel.orders.entities.FiscalItemType;
import ru.yandex.travel.orders.workflows.orderitem.hotel.AbstractHotelFiscalItemCreator;

@RequiredArgsConstructor
public class BnovoFiscalItemCreator extends AbstractHotelFiscalItemCreator<BNovoOrderItem> {
    private final BNovoConfigurationProperties properties;

    @Override
    protected void addProviderSpecificPropertiesToMainFiscalItem(FiscalItem item, BNovoOrderItem orderItem) {
        item.setType(FiscalItemType.EXPEDIA_HOTEL);
        item.setTitle(properties.getBilling().getFiscalTitle());
        item.setVatType(orderItem.getAgreement().getVatType());
        item.setInn(orderItem.getAgreement().getInn());
    }

    @Override
    protected void addProviderSpecificPropertiesToMealFiscalItem(FiscalItem fiscalItem, BNovoOrderItem orderItem) {
        fiscalItem.setTitle(properties.getBilling().getMealFiscalTitle());
    }
}
