package ru.yandex.travel.orders.workflows.orderitem.bnovo.handlers;

import com.google.common.base.Preconditions;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.hotels.common.orders.BNovoHotelItinerary;
import ru.yandex.travel.hotels.common.partners.base.CallContext;
import ru.yandex.travel.hotels.common.partners.bnovo.BNovoClient;
import ru.yandex.travel.orders.entities.BNovoOrderItem;
import ru.yandex.travel.orders.services.hotels.Meters;
import ru.yandex.travel.orders.workflow.hotels.bnovo.proto.EBNovoItemState;
import ru.yandex.travel.orders.workflow.hotels.bnovo.proto.TCancellationCommit;
import ru.yandex.travel.orders.workflow.hotels.bnovo.proto.TReservationExpired;
import ru.yandex.travel.orders.workflow.hotels.proto.TCancellationStart;
import ru.yandex.travel.orders.workflow.hotels.proto.TConfirmationStart;
import ru.yandex.travel.orders.workflow.order.proto.TServiceCancelled;
import ru.yandex.travel.orders.workflows.orderitem.bnovo.BNovoConfigurationProperties;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;
import ru.yandex.travel.workflow.base.IgnoreEvents;

@Slf4j
@IgnoreEvents(types = {TCancellationStart.class, TConfirmationStart.class, TReservationExpired.class})
public class CancellingStateHandler extends BaseBNovoHandler {
    private final BNovoClient client;

    public CancellingStateHandler(BNovoClient client, Meters meters, BNovoConfigurationProperties properties) {
        super(meters, properties);
        this.client = client;
    }

    @HandleEvent
    public void handleCancellationCommit(TCancellationCommit message,
                                         StateContext<EBNovoItemState, BNovoOrderItem> context) {
        BNovoHotelItinerary itinerary = context.getWorkflowEntity().getItinerary();
        Preconditions.checkNotNull(itinerary.getYandexNumber());
        Preconditions.checkNotNull(itinerary.getBNovoNumber());
        cancelAndGet(client.withCallContext(getCallContext(context.getWorkflowEntity(),
                CallContext.CallPhase.ORDER_CANCELLATION)), itinerary, false);
        log.info("CANCELLED");
        context.setState(EBNovoItemState.IS_CANCELLED);
        context.scheduleExternalEvent(context.getWorkflowEntity().getOrderWorkflowId(),
                TServiceCancelled.newBuilder().setServiceId(context.getWorkflowEntity().getId().toString()).build());
    }
}
