package ru.yandex.travel.orders.workflows.orderitem.bnovo.handlers;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.hotels.common.orders.CancellationDetails;
import ru.yandex.travel.hotels.proto.EPartnerId;
import ru.yandex.travel.orders.entities.BNovoOrderItem;
import ru.yandex.travel.orders.services.hotels.Meters;
import ru.yandex.travel.orders.services.partners.BillingPartnerService;
import ru.yandex.travel.orders.workflow.hotels.bnovo.proto.EBNovoItemState;
import ru.yandex.travel.orders.workflow.hotels.bnovo.proto.TReservationCommit;
import ru.yandex.travel.orders.workflow.hotels.proto.TReservationStart;
import ru.yandex.travel.orders.workflow.order.proto.TServiceCancelled;
import ru.yandex.travel.orders.workflows.orderitem.bnovo.BNovoConfigurationProperties;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
public class NewStateHandler extends BaseBNovoHandler {
    private final BillingPartnerService billingPartnerService;

    public NewStateHandler(Meters meters, BillingPartnerService billingPartnerService,
                           BNovoConfigurationProperties properties) {
        super(meters, properties);
        this.billingPartnerService = billingPartnerService;
    }

    @HandleEvent
    public void handleRegister(TReservationStart message,
                               StateContext<EBNovoItemState, BNovoOrderItem> context) {
        handleGenericRegister(null, context);
    }

    @HandleEvent
    public void handleGenericRegister(ru.yandex.travel.orders.workflow.orderitem.generic.proto.TReservationStart message,
                                      StateContext<EBNovoItemState, BNovoOrderItem> context) {
        var orderItem = context.getWorkflowEntity();

        try {
            billingPartnerService.addAgreementOrThrow(orderItem);
        } catch (Exception e) {
            log.info("Reserve {} is cancelled, because some problem with hotel agreement", orderItem.getOrder().getPrettyId());
            context.setState(EBNovoItemState.IS_CANCELLED);
            orderItem.getItinerary().setOrderCancellationDetails(CancellationDetails.create(CancellationDetails.Reason.SOLD_OUT));
            meters.incrementCancellationCounter(EPartnerId.PI_BNOVO, CancellationDetails.Reason.AGREEMENT_ISSUE);
            context.scheduleExternalEvent(context.getWorkflowEntity().getOrderWorkflowId(),
                    TServiceCancelled.newBuilder().setServiceId(context.getWorkflowEntity().getId().toString()).build());
            return;
        }

        context.setState(EBNovoItemState.IS_RESERVING);
        context.scheduleEvent(TReservationCommit.newBuilder().build());
        log.info("scheduled reservation");
    }
}
