package ru.yandex.travel.orders.workflows.orderitem.bnovo.handlers;

import com.google.common.base.Preconditions;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.hotels.common.orders.BNovoHotelItinerary;
import ru.yandex.travel.hotels.common.partners.base.CallContext;
import ru.yandex.travel.hotels.common.partners.bnovo.BNovoClient;
import ru.yandex.travel.orders.entities.BNovoOrderItem;
import ru.yandex.travel.orders.proto.THotelRefundToken;
import ru.yandex.travel.orders.services.hotels.Meters;
import ru.yandex.travel.orders.workflow.hotels.bnovo.proto.EBNovoItemState;
import ru.yandex.travel.orders.workflow.hotels.bnovo.proto.TRefundCommit;
import ru.yandex.travel.orders.workflows.orderitem.RefundingUtils;
import ru.yandex.travel.orders.workflows.orderitem.bnovo.BNovoConfigurationProperties;
import ru.yandex.travel.workflow.StateContext;
import ru.yandex.travel.workflow.base.HandleEvent;

@Slf4j
public class RefundingStateHandler extends BaseBNovoHandler {
    private final BNovoClient client;

    public RefundingStateHandler(BNovoClient client, Meters meters, BNovoConfigurationProperties properties) {
        super(meters, properties);
        this.client = client;
    }

    @HandleEvent
    public void handleRefundCommit(TRefundCommit message, StateContext<EBNovoItemState, BNovoOrderItem> context) {
        BNovoHotelItinerary itinerary = context.getWorkflowEntity().getItinerary();
        Preconditions.checkArgument(itinerary.getServiceId().equals(context.getWorkflowEntity().getId().toString()));
        Preconditions.checkNotNull(itinerary.getYandexNumber());
        cancelAndGet(client.withCallContext(getCallContext(context.getWorkflowEntity(),
                CallContext.CallPhase.ORDER_REFUND)), itinerary, message.getForce());
        THotelRefundToken refundToken = RefundingUtils.getRefundToken(message.getToken());
        itinerary.setRefundInfo(RefundingUtils.createRefundInfo(refundToken, message.getReason()));
        context.setState(EBNovoItemState.IS_REFUNDED);
        RefundingUtils.scheduleServiceRefundedEvent(context, refundToken,
                message.getSkipFinEvents(), message.getMoneyRefundMode(), message.getRefundDescription());
        log.info("REFUNDED");
    }
}
